/*
 * Decompiled with CFR 0.152.
 */
package com.rover12421.crack.jerbrains;

import com.rover12421.crack.jerbrains.RSAEncoder;
import java.math.BigInteger;
import java.util.Random;
import java.util.zip.CRC32;

public class GenericKeyMaker {
    public static final int LICENSETYPE_COMMERCIAL = 0;
    public static final int LICENSETYPE_NON_COMMERCIAL = 1;
    public static final int LICENSETYPE_SITE = 2;
    public static final int LICENSETYPE_OPENSOURCE = 3;
    public static final int LICENSETYPE_PERSONAL = 4;
    public static final int LICENSETYPE_YEARACADEMIC = 5;
    public static final int LICENSETYPE_CLASSROOM = 6;
    public static final int LICENSETYPE_FLOATING = 7;
    public static final int PRODUCTID_IDEA = 1;
    public static final int PRODUCTID_RubyMine = 4;
    public static final int PRODUCTID_PyCharm = 5;
    public static final int PRODUCTID_WebStorm = 6;
    public static final int PRODUCTID_PhpStorm = 7;
    public static final int PRODUCTID_AppCode = 8;
    public static final int PRODUCTID_DBIDE = 9;
    public static final int PRODUCTID_CLION = 10;
    private Random random = new Random();

    private String getLicenseId() {
        return String.format("D%sT", Integer.toString(this.random.nextInt(90000) + 10000));
    }

    private short getCRC(String s, int i, byte[] bytes) {
        CRC32 crc32 = new CRC32();
        if (s != null) {
            for (int j = 0; j < s.length(); ++j) {
                char c = s.charAt(j);
                crc32.update(c);
            }
        }
        crc32.update(i);
        crc32.update(i >> 8);
        crc32.update(i >> 16);
        crc32.update(i >> 24);
        for (int k = 0; k < bytes.length - 2; ++k) {
            byte byte0 = bytes[k];
            crc32.update(byte0);
        }
        return (short)crc32.getValue();
    }

    private byte[] generateKeyBytes14(int licenseType, int productId, int minorVersion, int majorVersion, String userName, int customerId) {
        byte[] keyBytes = new byte[14];
        keyBytes[0] = (byte)((licenseType << 4) + (productId & 0xFF));
        keyBytes[1] = (byte)((minorVersion << 4) + (majorVersion & 0xFF));
        long time = System.currentTimeMillis() >> 16;
        keyBytes[2] = (byte)(time & 0xFFL);
        keyBytes[3] = (byte)(time >> 8 & 0xFFL);
        keyBytes[4] = (byte)(time >> 16 & 0xFFL);
        keyBytes[5] = (byte)(time >> 24 & 0xFFL);
        long timeDiff = Long.MAX_VALUE;
        keyBytes[6] = (byte)(timeDiff & 0xFFL);
        keyBytes[7] = (byte)(timeDiff >> 8 & 0xFFL);
        keyBytes[8] = 0;
        keyBytes[9] = 1;
        keyBytes[10] = 2;
        keyBytes[11] = 3;
        short crc32 = this.getCRC(userName, customerId, keyBytes);
        keyBytes[12] = (byte)(crc32 & 0xFF);
        keyBytes[13] = (byte)(crc32 >> 8 & 0xFF);
        return keyBytes;
    }

    private byte[] generateKeyBytes12(int licenseType, int productId, int minorVersion, int majorVersion, String userName, int customerId) {
        byte[] keyBytes = new byte[12];
        keyBytes[0] = (byte)((licenseType << 4) + (productId & 0xFF));
        keyBytes[1] = (byte)((minorVersion << 4) + (majorVersion & 0xFF));
        long time = System.currentTimeMillis() >> 16;
        keyBytes[2] = (byte)(time & 0xFFL);
        keyBytes[3] = (byte)(time >> 8 & 0xFFL);
        keyBytes[4] = (byte)(time >> 16 & 0xFFL);
        keyBytes[5] = (byte)(time >> 24 & 0xFFL);
        long timeDiff = Long.MAX_VALUE;
        keyBytes[6] = (byte)(timeDiff & 0xFFL);
        keyBytes[7] = (byte)(timeDiff >> 8 & 0xFFL);
        keyBytes[8] = 105;
        keyBytes[9] = -59;
        short crc32 = this.getCRC(userName, customerId, keyBytes);
        keyBytes[10] = (byte)(crc32 & 0xFF);
        keyBytes[11] = (byte)(crc32 >> 8 & 0xFF);
        return keyBytes;
    }

    public static String encodeGroups(BigInteger biginteger) {
        BigInteger beginner1 = BigInteger.valueOf(60466176L);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (biginteger.compareTo(BigInteger.ZERO) != 0) {
            int j = biginteger.mod(beginner1).intValue();
            String s1 = GenericKeyMaker.encodeGroup(j);
            if (i > 0) {
                sb.append("-");
            }
            sb.append(s1);
            biginteger = biginteger.divide(beginner1);
            ++i;
        }
        return sb.toString();
    }

    public static String encodeGroup(int i) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < 5; ++j) {
            int k = i % 36;
            char c = k < 10 ? (char)(48 + k) : (char)(65 + k - 10);
            sb.append(c);
            i /= 36;
        }
        return sb.toString();
    }

    public String generateRSAKey(BigInteger privKey, BigInteger pubKey, int licenseType, int productId, int minorVersion, int majorVersion, String userName) {
        int customerId = this.random.nextInt(9000) + 1000;
        byte[] keyBytes = this.generateKeyBytes14(licenseType, productId, minorVersion, majorVersion, userName, customerId);
        RSAEncoder encoder = new RSAEncoder(privKey, pubKey, 64, false);
        String serial = encoder.encode(keyBytes);
        serial = "===== LICENSE BEGIN =====\n" + customerId + "-" + this.getLicenseId() + "\n" + serial + "\n===== LICENSE END =====";
        return serial;
    }

    public String generateNoRSAKey(BigInteger privKey, BigInteger pubKey, int licenseType, int productId, int minorVersion, int majorVersion, String userName) {
        int customerId = this.random.nextInt(9000) + 1000;
        byte[] keyBytes = this.generateKeyBytes12(licenseType, productId, minorVersion, majorVersion, userName, customerId);
        BigInteger k0 = new BigInteger(keyBytes);
        BigInteger k1 = k0.modPow(pubKey, privKey);
        String s0 = Integer.toString(customerId);
        String sz = "0";
        while (s0.length() != 5) {
            s0 = sz.concat(s0);
        }
        s0 = s0.concat("-");
        String s1 = GenericKeyMaker.encodeGroups(k1);
        s0 = s0.concat(s1);
        return s0;
    }
}

